
/*****************************************************************************
 *
 * Copyright 2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
*****************************************************************************/

/*!*********************************************************************************
*  @file    add_graph.hpp
*  @brief   ACF graph
***********************************************************************************/

#ifndef ADDGRAPH_HPP
#define ADDGRAPH_HPP

#include <acf_graph.hpp>

#ifdef APEX2_EMULATE
#include "acf_lib.hpp"
using namespace APEX2;
#endif

#include "add_graph_names.h"

#include "add_acf.h"

class AddGraph: public ACF_Graph
{
public:
  AddGraph() : ACF_Graph()
  {
    XREGISTER_ACF_KERNEL(ADD_K);
  }

  void Create()
  {
    //set identifier for graph
    SetIdentifier("AddGraph");

    //add kernels
    const std::string add_kernel("add_kernel");
    AddKernel(add_kernel, ADD_KN);

    //add graph ports
    AddInputPort(GR_INPUT0_IN);
    AddInputPort(GR_INPUT1_IN);
    AddOutputPort(GR_OUTPUT0_OUT);

    //specify connections
    Connect(GraphPort(GR_INPUT0_IN), KernelPort(add_kernel, ADD_KN_INA));
    Connect(GraphPort(GR_INPUT1_IN), KernelPort(add_kernel, ADD_KN_INB));
    Connect(KernelPort(add_kernel, ADD_KN_OUT), GraphPort(GR_OUTPUT0_OUT));
  }
};

#endif /* ADDGRAPH_HPP */
